﻿package{
	import flash.events.*
	import flash.display.*;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.geom.Point;
	import flash.geom.Rectangle;

	public class MoviesHolder extends Sprite{
		public var numItem:Number = 0;
		public var dispatcher:EventDispatcher = new EventDispatcher();
		public var arrHolders:Array = new Array();
		public var gapx:Number = 4;
		public var gapy:Number = 4;
		public var startx:Number = 0;
		public var starty:Number = 0;
		
		public var bound_width:Number;
		public var bound_height:Number;
		public var numColumns:Number = 0;
		public var itemWidth:Number = 0;
		public var itemHeight:Number = 0;
		
		public var lastSelectedHolder:ItemHolder = null;
		public var flagSelectedHolderOnCtrl:Boolean = false;
		
		public var arrSelectedHolders:Array = new Array();		
		public var counterLoadedItems:Number = 0;
		
		public var changeOrderItem:ItemHolder = null;
		public var modeDrag = "";
		public var spriteDragging:Sprite;
		public var flagDragStarted:Boolean = false;
		
		public var lastOverHolder:ItemHolder = null;
		
		
		//-------------------------------------------------------------------------
		//constructor:
		public function MoviesHolder(w:Number,h:Number){
			//init events			
			
			this.bound_width = Math.ceil(w);
			this.bound_height = Math.ceil(h);
		}
		
		//-------------------------------------------------------------------------
		// init the holders data. set to zero all items.
		public function initHoldersData(){
			this.lastSelectedHolder = null;
			this.flagSelectedHolderOnCtrl = false;
			
			this.arrSelectedHolders = new Array();		
			this.counterLoadedItems = 0;
			
			this.changeOrderItem = null;
			this.modeDrag = "";
			this.spriteDragging = null;
			this.flagDragStarted = false;
		}
		
		//-------------------------------------------------------------------------
		// return the items array
		public function getArrItems(){
			return(this.arrHolders);
		}
		
		//-------------------------------------------------------------------------
		//get array of selected items
		public function getArrSelectedItems(){
			return(this.arrSelectedHolders);
		}
		
		//-------------------------------------------------------------------------
		//get string of item ids seporated by comas
		public function getStrItemIds(){
			var strIDs:String = "";
			for(var i=0;i<this.arrHolders.length;i++){
				if(strIDs != "") strIDs += ",";
				strIDs += this.arrHolders[i].itemID;
			}			
			return(strIDs);
		}
		
		//-------------------------------------------------------------------------
		//get string of item selected ids seporated by comas
		public function getSelectedItemIds(){
			var strIDs:String = "";
			for(var i=0;i<this.arrSelectedHolders.length;i++){
				if(strIDs != "") strIDs += ",";
				strIDs += this.arrSelectedHolders[i].itemID;
			}			
			return(strIDs);
		}
		
		//-------------------------------------------------------------------------
		// invoked when all items loaded.
		public function loadedAllItems(){
			dispatcher.dispatchEvent(new Event("allHolderItemsLoaded"));
		}
		
		//-------------------------------------------------------------------------
		// send command to next holder to load it's item.
		private function loadNextItem(){
			if(this.counterLoadedItems >= this.arrHolders.length) return(false);
			this.arrHolders[this.counterLoadedItems].loadItemData();
		}
		
		//-------------------------------------------------------------------------
		// complete loading item. load next item
		private function holderLoadCompleteHandler(event:Event){
			this.counterLoadedItems++;
			loadNextItem();
		}
		
		
		//-------------------------------------------------------------------------
		// unselect all items
		public function unselectAllHolders(){
			for each(var holder:ItemHolder in this.arrHolders){
				holder.setNormal();
			}
		}
		
		//-------------------------------------------------------------------------
		// check whether you can drag item to change order with specific item.
		public function checkHolderOrdable(holder:ItemHolder){
			if(holder.isSelected()) return(false);
			
			//check if the holder is located after another selected holder
			var index1:Number = getHolderIndex(holder);
			if(index1 == 0) return(true);
			
			var nextHolder:ItemHolder = this.arrHolders[index1-1];
			
			if(nextHolder.isSelected()) return(false);
			  
			return(true);
		}
		
		//-------------------------------------------------------------------------
		// verify that there is only one selected file.
		public function verifyOneSelectedFile(){
			var website = this.parent.parent;
			if(this.arrSelectedHolders.length == 0){
				website.showDialog("error","Can't edit item name","No items selected");
				return(false);
			}
			if(this.arrSelectedHolders.length > 1){
				website.showDialog("error","Can't edit item name","There is more than 1 items selected");
				return(false);
			}
			return(true);
		}
		
		//-------------------------------------------------------------------------
		// check that there is only one item selected, and duplicate selected item
		public function duplicateSelectedItem(){
			if(verifyOneSelectedFile() == false) return(false);
			var holder:ItemHolder = this.arrSelectedHolders[0];
			var website = this.parent.parent;
			
			website.duplicateItemRequest(holder.itemID);
		}
		
		//-------------------------------------------------------------------------
		// check that there is only one item selected, and send website request to download it!
		public function downloadSelectedItem(){
			if(verifyOneSelectedFile() == false) return(false);
			var holder:ItemHolder = this.arrSelectedHolders[0];
			var website = this.parent.parent;
			website.downloadItemRequest(holder.itemID,holder.itemFilename);
		}
		
		//-------------------------------------------------------------------------
		// get current selected item data, and all items in category data
		public function previewSelectedItem(){
			var website = this.parent.parent;
			if(verifyOneSelectedFile() == false){
				website.hidePreviewPanel();
				return(false);
			}
			var selectedHolder:ItemHolder = this.arrSelectedHolders[0];
			website.previewCategoryItem(selectedHolder,this.arrHolders);
		}
		
		//-------------------------------------------------------------------------
		// preview some item by id
		public function previewItem(itemID){
			var website = this.parent.parent;
			var selectedHolder:ItemHolder = getItemById(itemID);
			if(selectedHolder == null) {
				website.showDialog("error","Can't preview item, no item found");
				return(false);
			}
			
			website.previewCategoryItem(selectedHolder,this.arrHolders);
		}
		
		//-------------------------------------------------------------------------
		// check that there is only one item selected, and move it to edit mode.
		public function editNameSelectedItem(){
			if(verifyOneSelectedFile() == false) return(false);
									
			var holder:ItemHolder = this.arrSelectedHolders[0];
			holder.changeToEditMode(false);
		}
		
		//-------------------------------------------------------------------------
		// start edit dialog of a selected item.
		public function editDescSelectedItem(){
			if(verifyOneSelectedFile() == false) return(false);
			var holder:ItemHolder = this.arrSelectedHolders[0];
			holder.startEditDesc();
		}
		
		//-------------------------------------------------------------------------
		// on mouseover event. check changing order actions.
		private function itemMouseOverHandler(event:MouseEvent){
			if(event.target is ItemHolder == false) return(false);
			
			if(modeDrag == "") return(false);
			switch(modeDrag){
				case "order":
					
					flagDragStarted = true;		//for blank area mouse up
					
					if(arrSelectedHolders.length == 0){
						trace("error - there is no selected items");
						return(false);
					}
				
					var hitItem:ItemHolder = ItemHolder(event.target);
					
					var mc_website = this.parent.parent;
					
					if(checkHolderOrdable(hitItem) == false){	//the item can be switched order
						mc_website.changeDragIcon("not_orderable");
						this.changeOrderItem = null;
						return(false);
					}
					
					this.changeOrderItem = hitItem;
					
					//push image from the selected item, and draw it before the hitItem.
					this.spriteDragging.visible = true;
					this.spriteDragging.x = Math.floor(hitItem.x-gapx/2-this.spriteDragging.width/2);
					this.spriteDragging.y = Math.floor(hitItem.y + (hitItem.height-this.spriteDragging.height)/2);
					
				break;
				default:
					trace("unknown drag mode");
				break;
			}
		}
		
		//-------------------------------------------------------------------------
		// on mouseout event. check changing order actions.
		private function itemMouseOutHandler(event:MouseEvent){
			if(event.target is ItemHolder == false) return(false);
						
			if(modeDrag == "") return(false);			
			switch(modeDrag){
				case "order":
					//setting drag icon
					var mc_website = this.parent.parent;
					mc_website.changeDragIcon("orderable");
					
					//dragging item handling:
					this.spriteDragging.visible = false;
					this.changeOrderItem = null;
				break;
			}
		}
		
		//-------------------------------------------------------------------------
		// invoke from the parent, where user clicks on the blank area.
		public function onBlankAreaMouseUp(){			
			//unselect the items only when the drag not started.
			if(this.flagDragStarted == true) return(false);
			else{
				unselectAllHolders();
				setArrSelectedHolders();
			}
		}
		
		//-------------------------------------------------------------------------
		// get array of selected items.
		public function setArrSelectedHolders(){
			this.arrSelectedHolders = new Array();
			var i:Number;
			for(i=0;i<this.arrHolders.length;i++){
				var holder:ItemHolder = arrHolders[i];
				if(holder.isSelected()) arrSelectedHolders.push(holder);
			}
			
			// if there is an holders - enable topPanel buttons.
			var website = this.parent.parent;
			if(this.arrSelectedHolders.length>0)
				website.mc_topPanel.enableItemSelectedButtons(true,this.arrSelectedHolders.length);
			else 
				website.mc_topPanel.enableItemSelectedButtons(false,0);
		}
		
		//-------------------------------------------------------------------------
		// get number of selected holders
		public function getNumSelectedHolders(){
			return(this.arrSelectedHolders.length);
		}
		
		//-------------------------------------------------------------------------
		// get string of selected item id's
		public function getStrSelectedItemIDs(){
			var str:String = "";
			if(this.arrSelectedHolders.length == 0) return(str);
			for(var i=0;i<this.arrSelectedHolders.length;i++){
				if(str != "") str += ",";
				str += this.arrSelectedHolders[i].itemID;
			}
			return(str);			
		}
		
		//-------------------------------------------------------------------------
		// get holder index.
		public function getHolderIndex(holder:ItemHolder){
			var i:Number;
			for(i=0;i<this.arrHolders.length;i++){
				if(this.arrHolders[i].name == holder.name) return(i);
			}
			return(-1);
		}
		
		//-------------------------------------------------------------------------
		// mouse down on item handler. start moving multiple items
		private function itemMouseUpHandler(event:MouseEvent){			
			if(event.target is ItemHolder == false) return(false);
			
			var holder:ItemHolder = ItemHolder(event.target);
			if(this.flagDragStarted == true) return(false);
			
			if(event.ctrlKey){	//ctrl key pressed - release one selected item
				if(this.flagSelectedHolderOnCtrl == true) return(false);
				holder.setNormal();
			}
			else if(event.shiftKey){
				return(false);
			}
			else{				//no buttons selected - if selected multiple, unselect others but pressed item.
				if(getNumSelectedHolders() == 1) return(false);
				setArrSelectedHolders();
				unselectAllHolders();
				holder.setSelected();
				this.lastSelectedHolder = holder;
			}
			
			setArrSelectedHolders();
		}				
		
		//-------------------------------------------------------------------------
		//adds all selected items to the end of new order array
		function addAllSelectedItemsToNewOrderedArray(arrNewOrderedHolders:Array){
			var i:Number;
			for(i=0;i<this.arrSelectedHolders.length;i++) 
				arrNewOrderedHolders.push(arrSelectedHolders[i]);
			return(arrNewOrderedHolders);
		}
		
		//-------------------------------------------------------------------------
		// set a new order to the holders. add all the unselected, until find the selected item, and 
		// then insert the selected ones, then continue with the unselected.
		public function reorderHolders(){
			var arrNewOrderedHolders = new Array();
			var i:Number,j:Number;
			for(i=0;i<this.arrHolders.length;i++){
				var holder:ItemHolder = this.arrHolders[i];
				if(holder.isSelected() == false){
					if(holder.name == this.changeOrderItem.name){
						arrNewOrderedHolders = addAllSelectedItemsToNewOrderedArray(arrNewOrderedHolders);
						arrNewOrderedHolders.push(holder);
					}
					else arrNewOrderedHolders.push(holder);
				}
			}
			this.arrHolders = arrNewOrderedHolders;
			placeAllItems();
			
			var mc_website = this.parent.parent;
			
			mc_website.saveItemsOrder();
		}
		
		//-------------------------------------------------------------------------
		// called from the website to stop the drag mode
		public function stopDragMode(){
			this.modeDrag = "";
			
			if(this.changeOrderItem != null) reorderHolders();
			
			this.flagDragStarted = false;
			this.changeOrderItem = null;
			this.removeChild(this.spriteDragging);
		}
		
		//-------------------------------------------------------------------------
		// tell website to drag an icon of dragging, get duplicated image
		public function startDragMode(){
			var mc_website = this.parent.parent;
			mc_website.startDragIcon("dragHolder",false);
			this.modeDrag = "order";
			this.flagDragStarted = false;
			this.changeOrderItem = null;
			
			var firstSelectedItem:ItemHolder = this.arrSelectedHolders[0];
			this.spriteDragging = firstSelectedItem.getDuplicatedData();					
			this.spriteDragging.visible = false;
			this.spriteDragging.mouseEnabled = false;

			this.addChild(this.spriteDragging);
		}
		
		
		//-------------------------------------------------------------------------
		// item mouse double click handler
		private function itemMouseDoubleClickHandler(event:MouseEvent){
			if(event.target is ItemHolder == false) return(false);
			var holder = event.target;
			previewItem(holder.itemID);
		}
		
		//-------------------------------------------------------------------------
		// mouse down on item handler. select the item.
		private function itemMouseDownHandler(event:MouseEvent){			
			if(event.target is ItemHolder == false) return(false);
			
			var holder:ItemHolder = ItemHolder(event.target);
			this.flagSelectedHolderOnCtrl = false;
			
			if(event.ctrlKey){	//ctrl key pressed - select multiple items.
				if(holder.isSelected() == false){
					holder.setSelected();
					this.lastSelectedHolder = holder;
					this.flagSelectedHolderOnCtrl = true;
					setArrSelectedHolders();
				}
			}
			else if(event.shiftKey){	//shift key pressed - select multiple from last selection.
				if(lastSelectedHolder == null) {
					holder.setSelected();
					this.lastSelectedHolder = holder;					
				}
				else{
					//select items from the first selected to second selected.
					
					var index1:Number = getHolderIndex(lastSelectedHolder);					
					var index2:Number = getHolderIndex(holder);
					
					var min:Number = Math.min(index1,index2);
					var max:Number = Math.max(index1,index2);
					
					var i:Number;
					
					unselectAllHolders();
					for(i=min;i<=max;i++){
						this.arrHolders[i].setSelected();
					}					
				}
				setArrSelectedHolders();
			}
			else{		//no key pressed, select one item.
				if(holder.isSelected() == false){
					unselectAllHolders();
					holder.setSelected();
					this.lastSelectedHolder = holder;
					setArrSelectedHolders();
				}
								
			}			
			startDragMode();
		}
		
		//-------------------------------------------------------------------------
		// clear item holders. remove them from the screen
		public function clearItemHolders(){
			for(var i=0;i<this.arrHolders.length;i++){
				var holder:ItemHolder = this.arrHolders[i];
				this.removeChild(holder);
			}
			this.arrHolders = new Array();
			initHoldersData();
		}
		
		//-------------------------------------------------------------------------
		//set theevents of an holder.
		public function setHolderEvents(mc_holder){
			mc_holder.addEventListener(MouseEvent.MOUSE_OUT,itemMouseOutHandler);
			mc_holder.addEventListener(MouseEvent.MOUSE_OVER,itemMouseOverHandler);
			mc_holder.addEventListener(MouseEvent.MOUSE_DOWN,itemMouseDownHandler);
			mc_holder.addEventListener(MouseEvent.DOUBLE_CLICK,itemMouseDoubleClickHandler);			
			mc_holder.addEventListener(MouseEvent.MOUSE_UP,itemMouseUpHandler);
		}
		
		//-------------------------------------------------------------------------
		//add or set items into the holders from an xml.
		public function addSetItems(listItems:XMLList,reset:Boolean){
			this.lastOverHolder = null;		//init over holder. there isn't any.
			if(this.arrHolders.length>0 && reset == true) clearItemHolders();
			
			this.counterLoadedItems = this.arrHolders.length;	//for loading pictures after.
			
			for each(var xmlItem:XML in listItems){
				var obj = new Object;
				obj.id = xmlItem.id;
				obj.filename = xmlItem.filename;
				obj.name = xmlItem.name;
				obj.itemDesc = xmlItem.itemDesc;
				obj.link = xmlItem.link;
				obj.itemOrder = xmlItem.itemOrder;
				obj.itemType = xmlItem.itemType;
				
				var mc_holder:ItemHolder = new ItemHolder();
				mc_holder.buttonMode = true;
				mc_holder.mouseChildren = false;				
				mc_holder.doubleClickEnabled = true;
				
				//set holder events:
				setHolderEvents(mc_holder);
				mc_holder.setData(obj);
				
				//set holder event
				mc_holder.dispatcher.addEventListener("itemLoadComplete",holderLoadCompleteHandler);
				
				this.arrHolders.push(mc_holder);
			}
			
			setNoItemsText();
			drawItems();			
			loadNextItem();		//set command to load the pictures of next item.
		}
		
		//-------------------------------------------------------------------------
		// set no items text (when there is no items)
		public function setNoItemsText(){
			var imagesPanel = this.parent;
			if(this.arrHolders.length == 0) imagesPanel.showNoImagesText(true);
			else imagesPanel.showNoImagesText(false);
		}
		
		//-------------------------------------------------------------------------
		//load items to holder: the arrItems always an object with filename property		
		public function setItems(listItems:XMLList){
			addSetItems(listItems,true);
		}
		
		//-------------------------------------------------------------------------
		// get item position according its place in the array
		public function addItems(listItems:XMLList){
			addSetItems(listItems,false);
		}
		
		//-------------------------------------------------------------------------
		// get item position according its place in the array
		public function getItemPos(place:Number){
			var row:Number = Math.floor(place / this.numColumns);
			var col:Number = place - this.numColumns*row;
			var objPos:Object = new Object;
			objPos.y = this.startx+row*(this.itemHeight+this.gapy);
			objPos.x = this.starty+col*(this.itemWidth+this.gapx);
			return(objPos);
		}
		
		//-------------------------------------------------------------------------
		//place item on its place
		public function placeItem(place){
			var objPos = getItemPos(place);
			var holder:ItemHolder = this.arrHolders[place];
			holder.x = objPos.x;
			holder.y = objPos.y;
		}
		
		//-------------------------------------------------------------------------
		// set place to all items according their position in array
		public function placeAllItems(){
			var i:Number;
			for(i=0;i<this.arrHolders.length;i++) placeItem(i);	
		}
		
		//-------------------------------------------------------------------------
		//draw items on the screen. Place them in their position.
		public function drawItems(){
			if(this.arrHolders.length == 0) return(false);
			var firstHolder:ItemHolder = this.arrHolders[0];
			this.numColumns = Math.floor(this.bound_width / (firstHolder.width+this.gapx));
			this.itemWidth = firstHolder.width;
			
			this.itemHeight = firstHolder.height;
			for(var i=0;i<this.arrHolders.length;i++){
				placeItem(i);				
				addChild(this.arrHolders[i]);
			}			
		}
		
		//-------------------------------------------------------------------------
		//hide over border from all items
		public function hideOverBorderFromLastHolder(){
			if(this.lastOverHolder == null) return(false);
			this.lastOverHolder.hideMouseOverBorder();
		}
		
		//-------------------------------------------------------------------------
		//select holders by selection points.
		public function selectHoldersBySelection(point1:Point,point2:Point,keyPressed:String){
			var minX:Number = Math.min(point1.x,point2.x);
			var maxX:Number = Math.max(point1.x,point2.x);
			var minY:Number = Math.min(point1.y,point2.y);
			var maxY:Number = Math.max(point1.y,point2.y);
			var i:Number,holder:ItemHolder;
			var rect1:Rectangle = new Rectangle(minX,minY,maxX-minX,maxY-minY);
			
			if(keyPressed == "none"){ 
				unselectAllHolders();
				hideOverBorderFromLastHolder();
			}
			
			for(i=0;i<this.arrHolders.length;i++){				
					holder = this.arrHolders[i];
					var rect2:Rectangle = new Rectangle(holder.x,holder.y,holder.width,holder.height);
					if(rect2.intersects(rect1)){
						if(keyPressed == "ctrl"){
							if(holder.isSelected()) holder.setNormal();
							else holder.setSelected();
						}
						else holder.setSelected();
					}
			}
			setArrSelectedHolders();
		}
		
		//-------------------------------------------------------------------------
		//remove items from the arrays and display
		public function removeItems(listItems:XMLList,toSelectNextItem:Boolean){
			this.lastOverHolder = null;
			var arrHoldersNew:Array = new Array();
			var arrHolderIDsToDelete:Array = new Array();
			var holder:ItemHolder;
			var i:Number;
			
			var nextHolderToBeSelected:ItemHolder = null;
			var flagLastSelected:Boolean = false;
			
			// make array of id's
			for(i=0;i<listItems.length();i++) arrHolderIDsToDelete.push(Number(listItems[i].toString()));						
			
			//go throught all items, and make a new array. delete items that in the list on the way.
			for(i=0;i<this.arrHolders.length;i++){				
				holder = this.arrHolders[i];
				
				if(toSelectNextItem == true && flagLastSelected == true) nextHolderToBeSelected = holder;
				
				if(arrHolderIDsToDelete.indexOf(holder.itemID) != -1){	//delete the holder. 
					this.removeChild(holder);
					flagLastSelected = true;
				}
				else{
					arrHoldersNew.push(holder);
					flagLastSelected = false;
				}
			}
						
			//switch between old and new arrays.
			this.arrHolders = arrHoldersNew;
			
			//set the holder to be selected to last holder left
			if(toSelectNextItem == true){
				if(nextHolderToBeSelected == null && this.arrHolders.length>0) nextHolderToBeSelected = this.arrHolders[this.arrHolders.length-1];
				if(nextHolderToBeSelected != null) nextHolderToBeSelected.setSelected();
			}
			
			setNoItemsText();
			placeAllItems();
			setArrSelectedHolders();
		}
		
		//-------------------------------------------------------------------------
		//get item by id. else return null
		public function getItemById(itemID:String){
			for(var i=0;i<this.arrHolders.length;i++){
				if(this.arrHolders[i].itemID == itemID) return(this.arrHolders[i]);
			}
			return(null);
		}
		
		//-------------------------------------------------------------------------
		//find an item by id, and update its properties.
		public function updateItemNameDesc(itemID:String,itemName:String,itemDesc:String,itemLink:String){
			var holder = getItemById(itemID);
			if(holder == null) return(false);
			holder.setNameDesc(itemName,itemDesc,itemLink);
		}
		
		//-------------------------------------------------------------------------
		//select all holder items
		public function selectAllItems(){
			for(var i=0;i<this.arrHolders.length;i++) this.arrHolders[i].setSelected();
			setArrSelectedHolders();
		}
		
		//-------------------------------------------------------------------------
		//select item by id. unselect all items if this item has found
		public function selectItemById(id:Number){
			var holder:ItemHolder = null;
			
			for(var i=0;i<this.arrHolders.length;i++){
				if(arrHolders[i].itemID == id) holder = this.arrHolders[i];
			}
			
			if(holder != null){				
				unselectAllHolders();
				holder.setSelected();
				setArrSelectedHolders();
			}
			
		}
		
		//-------------------------------------------------------------------------
		//unselect all items in holder.
		public function unselectAllItems(){
			for(var i=0;i<this.arrHolders.length;i++) this.arrHolders[i].setNormal();
			setArrSelectedHolders();
		}
		
	}
}